# Rule Directory

## Default Rules

* `block_based_kvo`: Block Based KVO
* `capture_variable`: Capture Variable
* `class_delegate_protocol`: Class Delegate Protocol
* `closing_brace`: Closing Brace Spacing
* `closure_body_length`: Closure Body Length
* `closure_end_indentation`: Closure End Indentation
* `closure_parameter_position`: Closure Parameter Position
* `closure_spacing`: Closure Spacing
* `collection_alignment`: Collection Element Alignment
* `colon`: Colon Spacing
* `comma`: Comma Spacing
* `comment_spacing`: Comment Spacing
* `compiler_protocol_init`: Compiler Protocol Init
* `computed_accessors_order`: Computed Accessors Order
* `conditional_returns_on_newline`: Conditional Returns on Newline
* `contains_over_filter_count`: Contains Over Filter Count
* `contains_over_filter_is_empty`: Contains Over Filter Is Empty
* `contains_over_first_not_nil`: Contains over first not nil
* `contains_over_range_nil_comparison`: Contains over range(of:) comparison to nil
* `control_statement`: Control Statement
* `convenience_type`: Convenience Type
* `custom_rules`: Custom Rules
* `cyclomatic_complexity`: Cyclomatic Complexity
* `deployment_target`: Deployment Target
* `discarded_notification_center_observer`: Discarded Notification Center Observer
* `discouraged_assert`: Discouraged Assert
* `discouraged_direct_init`: Discouraged Direct Initialization
* `discouraged_none_name`: Discouraged None Name
* `discouraged_object_literal`: Discouraged Object Literal
* `discouraged_optional_boolean`: Discouraged Optional Boolean
* `discouraged_optional_collection`: Discouraged Optional Collection
* `duplicate_enum_cases`: Duplicate Enum Cases
* `duplicate_imports`: Duplicate Imports
* `duplicated_key_in_dictionary_literal`: Duplicated Key in Dictionary Literal
* `dynamic_inline`: Dynamic Inline
* `empty_collection_literal`: Empty Collection Literal
* `empty_count`: Empty Count
* `empty_enum_arguments`: Empty Enum Arguments
* `empty_parameters`: Empty Parameters
* `empty_parentheses_with_trailing_closure`: Empty Parentheses with Trailing Closure
* `empty_string`: Empty String
* `empty_xctest_method`: Empty XCTest Method
* `enum_case_associated_values_count`: Enum Case Associated Values Count
* `expiring_todo`: ExpiringTodo
* `explicit_acl`: Explicit ACL
* `explicit_enum_raw_value`: Explicit Enum Raw Value
* `explicit_init`: Explicit Init
* `explicit_self`: Explicit Self
* `explicit_top_level_acl`: Explicit Top Level ACL
* `explicit_type_interface`: Explicit Type Interface
* `extension_access_modifier`: Extension Access Modifier
* `fallthrough`: Fallthrough
* `fatal_error_message`: Fatal Error Message
* `file_header`: File Header
* `file_length`: File Length
* `file_name`: File Name
* `file_name_no_space`: File Name No Space
* `file_types_order`: File Types Order
* `first_where`: First Where
* `flatmap_over_map_reduce`: FlatMap over map and reduce
* `for_where`: For Where
* `force_cast`: Force Cast
* `force_try`: Force Try
* `force_unwrapping`: Force Unwrapping
* `function_body_length`: Function Body Length
* `function_default_parameter_at_end`: Function Default Parameter at End
* `function_parameter_count`: Function Parameter Count
* `generic_type_name`: Generic Type Name
* `ibinspectable_in_extension`: IBInspectable in Extension
* `identical_operands`: Identical Operands
* `identifier_name`: Identifier Name
* `implicit_getter`: Implicit Getter
* `implicit_return`: Implicit Return
* `implicitly_unwrapped_optional`: Implicitly Unwrapped Optional
* `inclusive_language`: Inclusive Language
* `indentation_width`: Indentation Width
* `inert_defer`: Inert Defer
* `is_disjoint`: Is Disjoint
* `joined_default_parameter`: Joined Default Parameter
* `large_tuple`: Large Tuple
* `last_where`: Last Where
* `leading_whitespace`: Leading Whitespace
* `legacy_cggeometry_functions`: Legacy CGGeometry Functions
* `legacy_constant`: Legacy Constant
* `legacy_constructor`: Legacy Constructor
* `legacy_hashing`: Legacy Hashing
* `legacy_multiple`: Legacy Multiple
* `legacy_nsgeometry_functions`: Legacy NSGeometry Functions
* `legacy_objc_type`: Legacy Objective-C Reference Type
* `legacy_random`: Legacy Random
* `let_var_whitespace`: Variable Declaration Whitespace
* `line_length`: Line Length
* `literal_expression_end_indentation`: Literal Expression End Indentation
* `lower_acl_than_parent`: Lower ACL than parent
* `mark`: Mark
* `missing_docs`: Missing Docs
* `modifier_order`: Modifier Order
* `multiline_arguments`: Multiline Arguments
* `multiline_arguments_brackets`: Multiline Arguments Brackets
* `multiline_function_chains`: Multiline Function Chains
* `multiline_literal_brackets`: Multiline Literal Brackets
* `multiline_parameters`: Multiline Parameters
* `multiline_parameters_brackets`: Multiline Parameters Brackets
* `multiple_closures_with_trailing_closure`: Multiple Closures with Trailing Closure
* `nesting`: Nesting
* `nimble_operator`: Nimble Operator
* `no_extension_access_modifier`: No Extension Access Modifier
* `no_fallthrough_only`: No Fallthrough Only
* `no_grouping_extension`: No Grouping Extension
* `no_space_in_method_call`: No Space in Method Call
* `notification_center_detachment`: Notification Center Detachment
* `nslocalizedstring_key`: NSLocalizedString Key
* `nslocalizedstring_require_bundle`: NSLocalizedString Require Bundle
* `nsobject_prefer_isequal`: NSObject Prefer isEqual
* `number_separator`: Number Separator
* `object_literal`: Object Literal
* `opening_brace`: Opening Brace Spacing
* `operator_usage_whitespace`: Operator Usage Whitespace
* `operator_whitespace`: Operator Function Whitespace
* `optional_enum_case_matching`: Optional Enum Case Match
* `orphaned_doc_comment`: Orphaned Doc Comment
* `overridden_super_call`: Overridden methods call super
* `override_in_extension`: Override in Extension
* `pattern_matching_keywords`: Pattern Matching Keywords
* `prefer_nimble`: Prefer Nimble
* `prefer_self_in_static_references`: Prefer Self in Static References
* `prefer_self_type_over_type_of_self`: Prefer Self Type Over Type of Self
* `prefer_zero_over_explicit_init`: Prefer Zero Over Explicit Init
* `prefixed_toplevel_constant`: Prefixed Top-Level Constant
* `private_action`: Private Actions
* `private_outlet`: Private Outlets
* `private_over_fileprivate`: Private over fileprivate
* `private_subject`: Private Combine Subject
* `private_unit_test`: Private Unit Test
* `prohibited_interface_builder`: Prohibited Interface Builder
* `prohibited_super_call`: Prohibited calls to super
* `protocol_property_accessors_order`: Protocol Property Accessors Order
* `quick_discouraged_call`: Quick Discouraged Call
* `quick_discouraged_focused_test`: Quick Discouraged Focused Test
* `quick_discouraged_pending_test`: Quick Discouraged Pending Test
* `raw_value_for_camel_cased_codable_enum`: Raw Value For Camel Cased Codable Enum
* `reduce_boolean`: Reduce Boolean
* `reduce_into`: Reduce Into
* `redundant_discardable_let`: Redundant Discardable Let
* `redundant_nil_coalescing`: Redundant Nil Coalescing
* `redundant_objc_attribute`: Redundant @objc Attribute
* `redundant_optional_initialization`: Redundant Optional Initialization
* `redundant_set_access_control`: Redundant Set Access Control Rule
* `redundant_string_enum_value`: Redundant String Enum Value
* `redundant_type_annotation`: Redundant Type Annotation
* `redundant_void_return`: Redundant Void Return
* `required_deinit`: Required Deinit
* `required_enum_case`: Required Enum Case
* `return_arrow_whitespace`: Returning Whitespace
* `self_in_property_initialization`: Self in Property Initialization
* `shorthand_operator`: Shorthand Operator
* `single_test_class`: Single Test Class
* `sorted_first_last`: Min or Max over Sorted First or Last
* `sorted_imports`: Sorted Imports
* `statement_position`: Statement Position
* `static_operator`: Static Operator
* `strict_fileprivate`: Strict fileprivate
* `strong_iboutlet`: Strong IBOutlet
* `superfluous_disable_command`: Superfluous Disable Command
* `switch_case_alignment`: Switch and Case Statement Alignment
* `switch_case_on_newline`: Switch Case on Newline
* `syntactic_sugar`: Syntactic Sugar
* `test_case_accessibility`: Test case accessibility
* `todo`: Todo
* `toggle_bool`: Toggle Bool
* `trailing_closure`: Trailing Closure
* `trailing_comma`: Trailing Comma
* `trailing_newline`: Trailing Newline
* `trailing_semicolon`: Trailing Semicolon
* `trailing_whitespace`: Trailing Whitespace
* `type_body_length`: Type Body Length
* `type_contents_order`: Type Contents Order
* `type_name`: Type Name
* `unavailable_function`: Unavailable Function
* `unneeded_break_in_switch`: Unneeded Break in Switch
* `unneeded_parentheses_in_closure_argument`: Unneeded Parentheses in Closure Argument
* `unowned_variable_capture`: Unowned Variable Capture
* `untyped_error_in_catch`: Untyped Error in Catch
* `unused_capture_list`: Unused Capture List
* `unused_closure_parameter`: Unused Closure Parameter
* `unused_control_flow_label`: Unused Control Flow Label
* `unused_declaration`: Unused Declaration
* `unused_enumerated`: Unused Enumerated
* `unused_import`: Unused Import
* `unused_optional_binding`: Unused Optional Binding
* `unused_setter_value`: Unused Setter Value
* `valid_ibinspectable`: Valid IBInspectable
* `vertical_parameter_alignment`: Vertical Parameter Alignment
* `vertical_parameter_alignment_on_call`: Vertical Parameter Alignment On Call
* `vertical_whitespace`: Vertical Whitespace
* `vertical_whitespace_between_cases`: Vertical Whitespace Between Cases
* `vertical_whitespace_closing_braces`: Vertical Whitespace before Closing Braces
* `vertical_whitespace_opening_braces`: Vertical Whitespace after Opening Braces
* `void_return`: Void Return
* `weak_delegate`: Weak Delegate
* `xct_specific_matcher`: XCTest Specific Matcher
* `xctfail_message`: XCTFail Message
* `yoda_condition`: Yoda condition rule

## Opt-In Rules

* `anonymous_argument_in_multiline_closure`: Anonymous Argument in Multiline Closure
* `anyobject_protocol`: AnyObject Protocol
* `array_init`: Array Init
* `attributes`: Attributes
* `balanced_xctest_lifecycle`: Balanced XCTest life-cycle
* `capture_variable`: Capture Variable
* `closure_body_length`: Closure Body Length
* `closure_end_indentation`: Closure End Indentation
* `closure_spacing`: Closure Spacing
* `collection_alignment`: Collection Element Alignment
* `conditional_returns_on_newline`: Conditional Returns on Newline
* `contains_over_filter_count`: Contains Over Filter Count
* `contains_over_filter_is_empty`: Contains Over Filter Is Empty
* `contains_over_first_not_nil`: Contains over first not nil
* `contains_over_range_nil_comparison`: Contains over range(of:) comparison to nil
* `convenience_type`: Convenience Type
* `discarded_notification_center_observer`: Discarded Notification Center Observer
* `discouraged_assert`: Discouraged Assert
* `discouraged_none_name`: Discouraged None Name
* `discouraged_object_literal`: Discouraged Object Literal
* `discouraged_optional_boolean`: Discouraged Optional Boolean
* `discouraged_optional_collection`: Discouraged Optional Collection
* `empty_collection_literal`: Empty Collection Literal
* `empty_count`: Empty Count
* `empty_string`: Empty String
* `empty_xctest_method`: Empty XCTest Method
* `enum_case_associated_values_count`: Enum Case Associated Values Count
* `expiring_todo`: ExpiringTodo
* `explicit_acl`: Explicit ACL
* `explicit_enum_raw_value`: Explicit Enum Raw Value
* `explicit_init`: Explicit Init
* `explicit_self`: Explicit Self
* `explicit_top_level_acl`: Explicit Top Level ACL
* `explicit_type_interface`: Explicit Type Interface
* `extension_access_modifier`: Extension Access Modifier
* `fallthrough`: Fallthrough
* `fatal_error_message`: Fatal Error Message
* `file_header`: File Header
* `file_name`: File Name
* `file_name_no_space`: File Name No Space
* `file_types_order`: File Types Order
* `first_where`: First Where
* `flatmap_over_map_reduce`: FlatMap over map and reduce
* `force_unwrapping`: Force Unwrapping
* `function_default_parameter_at_end`: Function Default Parameter at End
* `ibinspectable_in_extension`: IBInspectable in Extension
* `identical_operands`: Identical Operands
* `implicit_return`: Implicit Return
* `implicitly_unwrapped_optional`: Implicitly Unwrapped Optional
* `indentation_width`: Indentation Width
* `joined_default_parameter`: Joined Default Parameter
* `last_where`: Last Where
* `legacy_multiple`: Legacy Multiple
* `legacy_objc_type`: Legacy Objective-C Reference Type
* `legacy_random`: Legacy Random
* `let_var_whitespace`: Variable Declaration Whitespace
* `literal_expression_end_indentation`: Literal Expression End Indentation
* `lower_acl_than_parent`: Lower ACL than parent
* `missing_docs`: Missing Docs
* `modifier_order`: Modifier Order
* `multiline_arguments`: Multiline Arguments
* `multiline_arguments_brackets`: Multiline Arguments Brackets
* `multiline_function_chains`: Multiline Function Chains
* `multiline_literal_brackets`: Multiline Literal Brackets
* `multiline_parameters`: Multiline Parameters
* `multiline_parameters_brackets`: Multiline Parameters Brackets
* `nimble_operator`: Nimble Operator
* `no_extension_access_modifier`: No Extension Access Modifier
* `no_grouping_extension`: No Grouping Extension
* `nslocalizedstring_key`: NSLocalizedString Key
* `nslocalizedstring_require_bundle`: NSLocalizedString Require Bundle
* `number_separator`: Number Separator
* `object_literal`: Object Literal
* `operator_usage_whitespace`: Operator Usage Whitespace
* `optional_enum_case_matching`: Optional Enum Case Match
* `overridden_super_call`: Overridden methods call super
* `override_in_extension`: Override in Extension
* `pattern_matching_keywords`: Pattern Matching Keywords
* `prefer_nimble`: Prefer Nimble
* `prefer_self_in_static_references`: Prefer Self in Static References
* `prefer_self_type_over_type_of_self`: Prefer Self Type Over Type of Self
* `prefer_zero_over_explicit_init`: Prefer Zero Over Explicit Init
* `prefixed_toplevel_constant`: Prefixed Top-Level Constant
* `private_action`: Private Actions
* `private_outlet`: Private Outlets
* `private_subject`: Private Combine Subject
* `prohibited_interface_builder`: Prohibited Interface Builder
* `prohibited_super_call`: Prohibited calls to super
* `quick_discouraged_call`: Quick Discouraged Call
* `quick_discouraged_focused_test`: Quick Discouraged Focused Test
* `quick_discouraged_pending_test`: Quick Discouraged Pending Test
* `raw_value_for_camel_cased_codable_enum`: Raw Value For Camel Cased Codable Enum
* `reduce_into`: Reduce Into
* `redundant_nil_coalescing`: Redundant Nil Coalescing
* `redundant_type_annotation`: Redundant Type Annotation
* `required_deinit`: Required Deinit
* `required_enum_case`: Required Enum Case
* `single_test_class`: Single Test Class
* `sorted_first_last`: Min or Max over Sorted First or Last
* `sorted_imports`: Sorted Imports
* `static_operator`: Static Operator
* `strict_fileprivate`: Strict fileprivate
* `strong_iboutlet`: Strong IBOutlet
* `switch_case_on_newline`: Switch Case on Newline
* `test_case_accessibility`: Test case accessibility
* `toggle_bool`: Toggle Bool
* `trailing_closure`: Trailing Closure
* `type_contents_order`: Type Contents Order
* `unavailable_function`: Unavailable Function
* `unneeded_parentheses_in_closure_argument`: Unneeded Parentheses in Closure Argument
* `unowned_variable_capture`: Unowned Variable Capture
* `untyped_error_in_catch`: Untyped Error in Catch
* `unused_declaration`: Unused Declaration
* `unused_import`: Unused Import
* `vertical_parameter_alignment_on_call`: Vertical Parameter Alignment On Call
* `vertical_whitespace_between_cases`: Vertical Whitespace Between Cases
* `vertical_whitespace_closing_braces`: Vertical Whitespace before Closing Braces
* `vertical_whitespace_opening_braces`: Vertical Whitespace after Opening Braces
* `weak_delegate`: Weak Delegate
* `xct_specific_matcher`: XCTest Specific Matcher
* `yoda_condition`: Yoda condition rule
